
<?php 
include '../../connection.php'; 

// Check if ID is provided in the URL
if (!isset($_GET['id'])) {
    header("Location: index.php"); // Redirect if no ID is provided
    exit();
}

$id = $_GET['id'];

// Retrieve existing data from mobile_banking table
$sqlRetrieve = "SELECT * FROM mobile_banking WHERE id = ?";
$stmtRetrieve = $con->prepare($sqlRetrieve);

if ($stmtRetrieve === false) {
    die('Prepare failed: ' . htmlspecialchars($con->error));
}

$stmtRetrieve->bind_param("i", $id);
$stmtRetrieve->execute();
$result = $stmtRetrieve->get_result();
$row = $result->fetch_assoc();

$stmtRetrieve->close();

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $gateway = $_POST['gateway'];
    $trans_type = $_POST['trans_type'];
    $mobile = $_POST['mobile'];
    $amount = $_POST['amount'];
	$adminNum = $_POST['adminNum'];
    $status = $_POST['status'];

    // Update the status in the mobile_banking table
    $sqlUpdate = "UPDATE mobile_banking SET gateway = ?, trans_type = ?, mobile = ?, amount = ?, status = ? WHERE id = ?";
    $stmtUpdate = $con->prepare($sqlUpdate);

    if ($stmtUpdate === false) {
        die('Prepare failed: ' . htmlspecialchars($con->error));
    }

    $stmtUpdate->bind_param("sssssi", $gateway, $trans_type, $mobile, $amount, $status, $id);

    if ($stmtUpdate->execute()) {
        // If status is accepted, deduct the amount from user's balance
        if ($status === 'Accepted') {
            // Retrieve the user ID associated with this transaction
            $userid = $row['userid']; // Assuming the userid is stored in the mobile_banking table

            // Deduct the amount from user's balance
            $sqlDeductBalance = "UPDATE balance SET amount = amount - ? WHERE userid = ?";
            $stmtDeductBalance = $con->prepare($sqlDeductBalance);

            if ($stmtDeductBalance === false) {
                die('Prepare failed: ' . htmlspecialchars($con->error));
            }

            $stmtDeductBalance->bind_param("di", $amount, $userid);

            if (!$stmtDeductBalance->execute()) {
                $_SESSION['message'] = "Failed to update balance.";
            }

            $stmtDeductBalance->close();

            // Insert notification for accepted status
            
			$message = 'এডমিন  আপনার মোবাইল ব্যাংকিং  রিকোয়েস্টটি   গ্রহণ ও সম্পন্ন করেছেন'.' - ' .$adminNum;
            $notificationStatus = 'Unread';
            $date = date('Y-m-d'); // Get current date and time

            $sqlInsertNotification = "INSERT INTO notification (userid, message, status, date) VALUES (?, ?, ?, ?)";
            $stmtInsertNotification = $con->prepare($sqlInsertNotification);

            if ($stmtInsertNotification === false) {
                die('Prepare failed: ' . htmlspecialchars($con->error));
            }

            $stmtInsertNotification->bind_param("isss", $userid, $message, $notificationStatus, $date);
            $stmtInsertNotification->execute();
            $stmtInsertNotification->close();
        } elseif ($status === 'Rejected') {
            // Insert notification for rejected status
            $userid = $row['userid']; // Assuming the userid is stored in the mobile_banking table
            $message = ' এডমিন  আপনার মোবাইল ব্যাংকিং রিকোয়েস্টটি   বাতিল করেছেন ';
            $notificationStatus = 'Unread';
            $date = date('Y-m-d'); // Get current date and time

            $sqlInsertNotification = "INSERT INTO notification (userid, message, status, date)
												VALUES (?, ?, ?, ?)";
            $stmtInsertNotification = $con->prepare($sqlInsertNotification);

            if ($stmtInsertNotification === false) {
                die('Prepare failed: ' . htmlspecialchars($con->error));
            }

            $stmtInsertNotification->bind_param("isss", $userid, $message, $notificationStatus, $date);
            $stmtInsertNotification->execute();
            $stmtInsertNotification->close();
        }
        
        $_SESSION['message'] = "Update successful.";
    } else {
        $_SESSION['message'] = "Error updating record.";
    }

    $stmtUpdate->close();
    header("Location: mobile-banking-request.php");
    exit();
}
?>


<?php

include 'header-link.php'; 
include 'nav-bar.php'; 
include 'header-top-chat.php'; 

?>
<!-- [ Main Content ] start -->
<div class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ breadcrumb ] start -->
                        <div class="page-header text-center">
                            <div class="page-block">
                                <div class="row align-items-center">
                                    <div class="col-md-12">
                                        <div class="page-header-title">
                                            <h5 class="m-b-10"> Mobile Banking Approval</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ Main Content ] start -->
                        <div class="row justify-content-center">
                            <!-- [ form-element ] start -->
                            <div class="col-lg-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5> Mobile Banking Approval </h5>
                                    </div>
                                    <div class="card-body">
                                        <form method="POST">
                                            <div class="form-group">
                                                <label class="form-label"> Gateway </label>
                                                <input type="text" name="gateway" class="form-control" value="<?php echo htmlspecialchars($row['gateway']); ?>" required>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label"> Transaction Type </label>
                                                <input type="text" name="trans_type" class="form-control" value="<?php echo htmlspecialchars($row['trans_type']); ?>" required>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label"> Mobile No </label>
                                                <input type="text" name="mobile" class="form-control" value="<?php echo htmlspecialchars($row['mobile']); ?>" required>
                                            </div>
											
                                            <div class="form-group">
                                                <label class="form-label"> Amount </label>
                                                <input type="text" name="amount" class="form-control" value="<?php echo htmlspecialchars($row['amount']); ?>" required>
                                            </div>
											
											 <div class="form-group">
                                                <label class="form-label"> Admin Number </label>
                                                <input type="text" name="adminNum" class="form-control" Placeholder="Admin Number" required>
                                            </div>
											
                                            <div class="form-group">
                                                <label class="form-label"> Choose Status </label>
                                                <select name="status" class="form-select form-control" required>
                                                    <option value="Pending" <?php echo $row['status'] === 'Pending' ? 'selected' : ''; ?>>Pending</option>
                                                    <option value="Accepted" <?php echo $row['status'] === 'Accepted' ? 'selected' : ''; ?>>Accepted</option>
													<option value="Rejected" <?php echo $row['status'] === 'Rejected' ? 'selected' : ''; ?>>Rejected</option>
                                                </select>
                                            </div>
                                            <div class="card-footer">
                                                <button type="submit" class="btn btn-primary me-2">Submit</button>
                                                <a class="btn btn-light" href="index.php"> Go Back </a>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ Main Content ] end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- [ Main Content ] end -->

<?php include 'footer.php'; ?>
